/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.scoreboard;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

final class CraftCriteria {
    static final Map<String, CraftCriteria> DEFAULTS;
    static final CraftCriteria DUMMY;
    final ObjectiveCriteria criteria;
    final String bukkitName;

    private CraftCriteria(String bukkitName) {
        this.bukkitName = bukkitName;
        this.criteria = CraftCriteria.DUMMY.criteria;
    }

    private CraftCriteria(ObjectiveCriteria criteria) {
        this.criteria = criteria;
        this.bukkitName = criteria.m_83620_();
    }

    static CraftCriteria getFromNMS(Objective objective) {
        return DEFAULTS.get(objective.m_83321_().m_83620_());
    }

    static CraftCriteria getFromBukkit(String name) {
        CraftCriteria criteria = DEFAULTS.get(name);
        if (criteria != null) {
            return criteria;
        }
        return new CraftCriteria(name);
    }

    public boolean equals(Object that) {
        if (!(that instanceof CraftCriteria)) {
            return false;
        }
        return ((CraftCriteria)that).bukkitName.equals(this.bukkitName);
    }

    public int hashCode() {
        return this.bukkitName.hashCode() ^ CraftCriteria.class.hashCode();
    }

    static {
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (Map.Entry entry : ObjectiveCriteria.f_166108_.entrySet()) {
            String name = (String)entry.getKey();
            ObjectiveCriteria criteria = (ObjectiveCriteria)entry.getValue();
            defaults.put((Object)name, (Object)new CraftCriteria(criteria));
        }
        DEFAULTS = defaults.build();
        DUMMY = DEFAULTS.get("dummy");
    }
}

